# Audio Manager

## Overview of the Add-On Features

The NVDA Audio Manager add-on is designed to help you manage multiple audio devices and optimize audio routing effectively.

The functionalities of this add-on can be categorized into four main modules:

- **Playback Device Management**: This module enables volume adjustment, setting of the system's default playback device, and toggling between mute and unmute states.
- **Recording Device Management**: Similar to the playback device management, this allows for volume control, setting of the system's default recording device, and muting/unmuting.
- **Application-specific Audio Control**: This feature facilitates the customization of playback and recording devices, volume modification, and muting/unmuting for individual audio applications.
- **Additional Functionalities**: Alongside the features mentioned above, there are several practical functionalities such as microphone volume lock, NVDA output device switching, etc.

## Function Hotkeys

| Features                                                                                                                                                                  | Desktop layout                           | Laptop layout                       |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------- | ----------------------------------- |
| Previous Recording Device                                                                                                                                                 | control+windows+alt+numpad1              | control+windows+alt+Home            |
| Next Recording Device                                                                                                                                                     | control+windows+alt+numpad3              | control+windows+alt+End             |
| Previous Playback Device                                                                                                                                                  | control+windows+alt+numpad4              | control+windows+alt+PageUp          |
| Next Playback Device                                                                                                                                                      | control+windows+alt+numpad6              | control+windows+alt+PageDown        |
| Previous Audio Application                                                                                                                                                | control+windows+alt+numpad7              | control+windows+alt+LeftArrow       |
| Next Audio Application                                                                                                                                                    | control+windows+alt+numpad9              | control+windows+alt+RightArrow      |
| Increase Volume                                                                                                                                                           | control+windows+alt+numpad8              | control+windows+alt+UpArrow         |
| Reduce Volume                                                                                                                                                             | control+windows+alt+numpad2              | control+windows+alt+DownArrow       |
| Mute/Unmute                                                                                                                                                               | control+windows+alt+numpad5              | control+windows+alt +Space          |
| Set default playback/recording device                                                                                                                                     | control+windows+alt+numpadEnter          | control+windows+alt+Enter           |
| Previous recording device for audio application                                                                                                                           | shift+control+windows+alt+numpadDivide   | shift+control+windows+alt+[         |
| Next Recording Device for Audio Applications                                                                                                                              | control+windows+alt+numpadDivide         | control+windows+alt+[               |
| Previous playback device for audio application                                                                                                                            | shift+control+windows+alt+numpadMultiply | shift+control+windows+alt+]         |
| Next playback device for audio applications                                                                                                                               | control+windows+alt+numpadMultiply       | control+windows+alt+]               |
| Restore audio application parameters (click to reset all audio application playback and recording devices, double-click to reset all audio application volume and unmute) | control+windows+alt+numpadMinus          | control+windows+alt+Backspace       |
| Previous NVDA playback device                                                                                                                                             | shift+control+windows+alt+numpadPlus     | shift+control+windows+alt+\         |
| Next NVDA playback device                                                                                                                                                 | control+windows+alt+numpadPlus           | control+windows+alt+\               |
| Mute/Unmute Current Window                                                                                                                                                | shift+control+windows+alt+numpad8        | shift+control+windows+alt+Space     |
| Sound Switch                                                                                                                                                              | shift+control+windows+alt+numpad5        | shift+control+windows+alt+UpArrow   |
| Microphone Switch                                                                                                                                                         | shift+control+windows+alt+numpad2        | shift+control+windows+alt+DownArrow |
| Lock/Unlock Microphone Volume                                                                                                                                             | control+windows+alt+numpadDelete         | control+windows+alt+Delete          |

## Contact feedback

If you have any opinions or suggestions, please feel free to communicate:

- Email: huaiyinfeilong@163.com
- QQ: 354522977
- WeChat: huaiyinfeilong

## Acknowledgements

Special thanks to Cary-rowen,雪岭冰龙 and 社会主义好 for their help and support during the development of the plugin.

## Upgrade log

### Version 1.0.7

- Added support for Ukrainian localization.
- Changed the desktop layout gesture to be effective across all layouts, consistent with NVDA core gestures.

### Version 1.0.6

- Adapt to NVDA 2024.1.
- Enhance compatibility stability.

### Version 1.0.5

- For unsupported system versions, a prompt will be provided during plugin installation.

### Version 1.0.4

- Improve program compatibility and fix incompatibilities with certain software.
- Fix the issue where setting default playback and recording devices may not take effect.

### Version 1.0.3

- Modify the audio application name acquisition method, and synchronize the application window title.
- Fix some bugs.

### Version 1.0.2

- Fix the problem that the microphone volume is not remembered after restarting after locking the microphone under certain circumstances.

### Version 1.0.1

- Fixed some audio applications not showing up.
- Improved some hints.
