# screenWrapping
# Copyright 2018 Hamada Trichine, released under GPLv2.

import config
from speech import cancelSpeech
from ui import message
from tones import beep

import addonHandler
addonHandler.initTranslation()

DIRECTION_NEXT = "next"
DIRECTION_PREV = "previous"

def playBeep(hz, length):
	if config.conf["screenWrapping"]["turnOnBeeps"]:
		beep(hz, length)

def alertWrp(direction):
	cancelSpeech()
	if direction == DIRECTION_PREV:
		# Translators: Text spoken when screen wrapping to bottom.
		message(_("Bottom"))
		playBeep(600, 20)
	else:
		# Translators: Text spoken when screen wrapping to top.
		message(_("Top"))
		playBeep(700, 20)

def alertToggleFunctionality(state):
	if state:
		message(
			# Translators: Text spoken when screen wrapping is turned off.
			_("Screen wrapping off."))
	else:
		message(
			# Translators: Text spoken when screen wrapping is turned on.
			_("Screen wrapping on."))