# pip install wxpython

import wx

class BinaryConverterApp(wx.Frame):
    def __init__(self, parent, title):
        super(BinaryConverterApp, self).__init__(parent, title=title, size=(400, 300))

        self.init_ui()
        self.Centre()

    def init_ui(self):
        panel = wx.Panel(self)
        vbox = wx.BoxSizer(wx.VERTICAL)

        # Radio Buttons for Conversion Choice
        self.radio_binary_to_decimal = wx.RadioButton(panel, label='Binary to Decimal', style=wx.RB_GROUP)
        self.radio_decimal_to_binary = wx.RadioButton(panel, label='Decimal to Binary')

        vbox.Add(self.radio_binary_to_decimal, flag=wx.LEFT | wx.TOP, border=10)
        vbox.Add(self.radio_decimal_to_binary, flag=wx.LEFT | wx.TOP, border=10)

        # Input field
        self.input_label = wx.StaticText(panel, label="Enter number:")
        self.input_text = wx.TextCtrl(panel)

        vbox.Add(self.input_label, flag=wx.LEFT | wx.TOP, border=10)
        vbox.Add(self.input_text, flag=wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, border=10)

        # Convert Button
        convert_button = wx.Button(panel, label='Convert')
        convert_button.Bind(wx.EVT_BUTTON, self.on_convert)

        vbox.Add(convert_button, flag=wx.ALIGN_CENTER | wx.TOP, border=10)

        # Result Display
        self.result_label = wx.StaticText(panel, label="", style=wx.ALIGN_CENTER)
        vbox.Add(self.result_label, flag=wx.ALIGN_CENTER | wx.ALL, border=10)

        panel.SetSizer(vbox)

    def on_convert(self, event):
        input_value = self.input_text.GetValue().strip()

        if self.radio_binary_to_decimal.GetValue():
            result = self.binary_to_decimal(input_value)
            self.result_label.SetLabel(result)
        elif self.radio_decimal_to_binary.GetValue():
            try:
                decimal_number = int(input_value)
                result = self.decimal_to_binary(decimal_number)
                self.result_label.SetLabel(result)
            except ValueError:
                self.result_label.SetLabel("Invalid decimal number.")

    def binary_to_decimal(self, binary_str):
        try:
            # Convert binary string to a decimal integer
            decimal_number = int(binary_str, 2)
            return f"Decimal: {decimal_number}"
        except ValueError:
            return "Invalid binary number."

    def decimal_to_binary(self, decimal_number):
        try:
            # Convert decimal integer to a binary string
            binary_str = bin(decimal_number)[2:]
            return f"Binary: {binary_str}"
        except TypeError:
            return "Invalid decimal number."

def main():
    app = wx.App()
    frame = BinaryConverterApp(None, "Binary <-> Decimal Converter")
    frame.Show()
    app.MainLoop()

if __name__ == "__main__":
    main()