# pip install mastodon.py
from mastodon import Mastodon
import webbrowser
import os

# --- ASK USER FOR INSTANCE ---
instance_url = input("Enter your Mastodon instance URL (e.g. https://mastodon.social): ").strip().rstrip("/")

# --- BASIC CONFIG ---
APP_NAME = "MastoPy"
SCOPES = ["read", "write"]
CRED_DIR = "mastodon_creds"

# Make sure the credential directory exists
os.makedirs(CRED_DIR, exist_ok=True)

# Filenames will depend on instance domain
safe_domain = instance_url.replace("https://", "").replace("http://", "").replace("/", "_")
APP_CRED_FILE = os.path.join(CRED_DIR, f"{safe_domain}_app.secret")
USER_TOKEN_FILE = os.path.join(CRED_DIR, f"{safe_domain}_user.secret")

# --- REGISTER APP IF NEEDED ---
if not os.path.exists(APP_CRED_FILE):
    print(f"Registering app for {instance_url}...")
    Mastodon.create_app(
        APP_NAME,
        scopes=SCOPES,
        api_base_url=instance_url,
        to_file=APP_CRED_FILE
    )
    print("App registered.")

# --- AUTHENTICATE USER ---
mastodon = Mastodon(client_id=APP_CRED_FILE, api_base_url=instance_url)

if not os.path.exists(USER_TOKEN_FILE):
    print("Opening browser for authentication...")
    auth_url = mastodon.auth_request_url(
        client_id=APP_CRED_FILE,
        scopes=SCOPES,
        redirect_uris="urn:ietf:wg:oauth:2.0:oob"
    )

    webbrowser.open(auth_url)
    print("\nIf the browser didn't open, go to this URL manually:")
    print(auth_url)
    code = input("\nPaste the authorization code here: ").strip()

    mastodon.log_in(code=code, scopes=SCOPES, to_file=USER_TOKEN_FILE)
    print("✅ Authentication successful! Token saved.")

# --- USE TOKEN ---
mastodon = Mastodon(access_token=USER_TOKEN_FILE, api_base_url=instance_url)

# --- POST A STATUS ---
status_text = input("\nEnter a status to post: ")
mastodon.status_post(status_text)
print(f"✅ Successfully posted to {instance_url}!")
