# pip install paramiko

import sys
import paramiko

def sftp_upload(hostname, port, username, password, localfile, remotefile):
    # Create an SSH client
    ssh = paramiko.SSHClient()
    # Automatically add the remote server's SSH key
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())

    try:
        # Connect to the server
        ssh.connect(hostname, port=port, username=username, password=password)
        print(f"Connected to {hostname}")

        # Open an SFTP session
        with ssh.open_sftp() as sftp:
            sftp.put(localfile, remotefile)
            print(f"Successfully uploaded {localfile} to {remotefile}")

    except Exception as e:
        print(f"Failed to upload file: {e}")

    finally:
        ssh.close()

if __name__ == '__main__':
    # Ensure all arguments are provided
    if len(sys.argv) != 7:
        print("Usage: sftpuploader [hostname] [port] [username] [password] [localfile] [remotefile]")
        sys.exit(1)

    hostname = sys.argv[1]
    port = int(sys.argv[2])
    username = sys.argv[3]
    password = sys.argv[4]
    localfile = sys.argv[5]
    remotefile = sys.argv[6]

    sftp_upload(hostname, port, username, password, localfile, remotefile)