# This script is meant to be used with the gamdl Apple Music downloader (https://github.com/glomatico/gamdl.git). It copies all music into a folder called "music", making it easy to deploy on instances of AzuraCast, for example.

import os
import shutil
import re

# List of common audio file extensions
AUDIO_EXTENSIONS = {".mp3", ".wav", ".flac", ".aac", ".ogg", ".m4a", ".wma", ".aiff"}

# Create the "files" directory if it doesn't exist
target_dir = os.path.join(os.getcwd(), "music")
os.makedirs(target_dir, exist_ok=True)

def clean_filename(filename):
    """
    Remove leading numbers, spaces, dots, or hyphens from a filename.
    Example: '01 Clair De Lune.m4a' -> 'Clair De Lune.m4a'
    """
    return re.sub(r'^\s*\d+[\s.\-]*', '', filename)

# Walk through current directory recursively
for root, _, files in os.walk(os.getcwd()):
    # Skip the target "files" directory to avoid copying into itself
    if os.path.abspath(root) == os.path.abspath(target_dir):
        continue

    for file in files:
        _, ext = os.path.splitext(file)
        if ext.lower() in AUDIO_EXTENSIONS:
            source_path = os.path.join(root, file)
            cleaned_name = clean_filename(file)
            destination_path = os.path.join(target_dir, cleaned_name)

            # If there's a name collision, add a counter
            counter = 1
            while os.path.exists(destination_path):
                name, ext = os.path.splitext(cleaned_name)
                destination_path = os.path.join(target_dir, f"{name}_{counter}{ext}")
                counter += 1

            shutil.copy2(source_path, destination_path)
            print(f"Copied: {source_path} -> {destination_path}")
