# pip install wxpython

import wx

class ProgressBarFrame(wx.Frame):
    def __init__(self):
        super().__init__(parent=None, title="Arrow Key Progress Bar", size=(400, 150))
        panel = wx.Panel(self)

        self.progress = wx.Gauge(panel, range=100, size=(300, 30))
        self.current_value = 50
        self.progress.SetValue(self.current_value)

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.progress, 0, wx.ALL | wx.CENTER, 20)
        panel.SetSizer(sizer)

        # Use EVT_CHAR_HOOK to capture arrow keys
        self.Bind(wx.EVT_CHAR_HOOK, self.on_key)

        self.Show()

    def on_key(self, event):
        key = event.GetKeyCode()
        if key == wx.WXK_RIGHT:
            self.current_value = min(100, self.current_value + 1)
        elif key == wx.WXK_LEFT:
            self.current_value = max(0, self.current_value - 1)
        self.progress.SetValue(self.current_value)

if __name__ == "__main__":
    app = wx.App(False)
    frame = ProgressBarFrame()
    app.MainLoop()
