import os
import webbrowser
import urllib.request
from pathlib import Path
import ctypes
import ctypes.wintypes as wintypes
import globalPluginHandler
import ui
from scriptHandler import script
import inputCore

def copy_to_clipboard(text):
    # Windows clipboard constants
    CF_UNICODETEXT = 13
    kernel32 = ctypes.windll.kernel32
    user32 = ctypes.windll.user32

    user32.OpenClipboard(0)
    user32.EmptyClipboard()

    hGlobal = kernel32.GlobalAlloc(0x2000, (len(text) + 1) * ctypes.sizeof(wintypes.WCHAR))
    lpGlobal = kernel32.GlobalLock(hGlobal)

    ctypes.memmove(lpGlobal, ctypes.create_unicode_buffer(text), (len(text) + 1) * ctypes.sizeof(wintypes.WCHAR))
    kernel32.GlobalUnlock(hGlobal)

    user32.SetClipboardData(CF_UNICODETEXT, hGlobal)
    user32.CloseClipboard()

class GlobalPlugin(globalPluginHandler.GlobalPlugin):
    __gesturesCategory = "MGEnhancements"

    def __init__(self):
        super().__init__()

    @script(
        description="Retrieve public IP address and copy to clipboard.",
        category=__gesturesCategory,
        gesture="kb:nvda+control+shift+i",
    )
    def script_copyPublicIP(self, gesture):
        try:
            with urllib.request.urlopen("https://net.mad-gamer.com/ip", timeout=5) as response:
                ip = response.read().decode('utf-8').strip()
                if ip:
                    copy_to_clipboard(ip)
                    ui.message("Your IP address has been copied to your clipboard.")
                else:
                    ui.message("Unable to retrieve your IP address. Check your internet connection and try again.")
        except Exception:
            ui.message("Unable to retrieve your IP address. Check your internet connection and try again.")

    @script(
        description="Opens the Documents folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+t",
    )
    def script_openDocuments(self, gesture):
        try:
            documents_path = str(Path.home() / "Documents")
            os.startfile(documents_path)
            ui.message(f"Opened Documents folder: {documents_path}")
        except Exception as e:
            ui.message(f"Error opening Documents folder: {e}")

    @script(
        description="Opens the Downloads folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+control+shift+d",
    )
    def script_openDownloads(self, gesture):
        try:
            downloads_path = str(Path.home() / "Downloads")
            os.startfile(downloads_path)
            ui.message(f"Opened Downloads folder: {downloads_path}")
        except Exception as e:
            ui.message(f"Error opening Downloads folder: {e}")

    @script(
        description="Opens the default web browser.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+b",
    )
    def script_openDefaultBrowser(self, gesture):
        try:
            webbrowser.open("https://www.google.com", new=1)
            ui.message("Opened the default web browser.")
        except Exception as e:
            ui.message(f"Error opening the browser: {e}")

    @script(
        description="Opens the AppData folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+a",
    )
    def script_openAppData(self, gesture):
        try:
            appdata_path = os.getenv('APPDATA')
            os.startfile(appdata_path)
            ui.message(f"Opened AppData folder: {appdata_path}")
        except Exception as e:
            ui.message(f"Error opening AppData folder: {e}")

    @script(
        description="Opens the Program Files folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+p",
    )
    def script_openProgramFiles(self, gesture):
        try:
            program_files_path = "C:\\Program Files"
            os.startfile(program_files_path)
            ui.message(f"Opened Program Files folder: {program_files_path}")
        except Exception as e:
            ui.message(f"Error opening Program Files folder: {e}")

    @script(
        description="Opens the Program Files (x86) folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+f",
    )
    def script_openProgramFilesX86(self, gesture):
        try:
            program_files_x86_path = os.getenv('ProgramFiles(x86)')
            os.startfile(program_files_x86_path)
            ui.message(f"Opened Program Files (x86) folder: {program_files_x86_path}")
        except Exception as e:
            ui.message(f"Error opening Program Files (x86) folder: {e}")

    @script(
        description="Opens the user's home folder.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+h",
    )
    def script_openHome(self, gesture):
        try:
            home_path = str(Path.home())
            os.startfile(home_path)
            ui.message(f"Opened Home folder: {home_path}")
        except Exception as e:
            ui.message(f"Error opening Home folder: {e}")

    @script(
        description="Opens the Command Prompt.",
        category=__gesturesCategory,
        gesture="kb:nvda+shift+control+n",
    )
    def script_openCommandPrompt(self, gesture):
        try:
            command_prompt_path = "C:\\Windows\\System32\\cmd.exe"
            os.startfile(command_prompt_path)
            ui.message("Opened Command Prompt.")
        except Exception as e:
            ui.message(f"Error opening Command Prompt: {e}")
